//
//  MCExportRuleManager.h
//  MCClientServer
//
//  Created by Brent Gulanowski on 18/06/08.
//  Copyright 2008 Marketcircle, Inc. All rights reserved.
//

#import <Foundation/Foundation.h>

#import "MCExportRule.h"

@class MCPModel;

@interface MCExportRuleManager : NSObject {

	MCPModel *model;
	NSString *configFilePath;
	NSDictionary *substitutionMap;
	NSMutableDictionary *exportRules;
	NSArray *orderedRuleNames;
	NSArray *tempTableEntities;
}

+ (MCExportRuleManager *)sharedManager;
+ (void)setSharedManager:(MCExportRuleManager *)anExportManager;

- (id)initWithModel:(MCPModel *)aModel substitutionMap:(NSDictionary *)aMap configFilePath:(NSString *)plistPath;

- (NSString *)configFilePath;
- (void)setConfigFilePath:(NSString *)aPath;
- (NSDictionary *)substitutionMap;
- (void)setSubstitutionMap:(NSDictionary *)aMap;
- (NSArray *)tempTableEntities;

// loaded lazily
- (NSDictionary *)exportRules;
- (NSArray *)orderedRuleNames;
- (MCExportRule *)ruleWithName:(NSString *)ruleName;
- (NSString *)tempTableNameForEntityName:(NSString *)entityName;

@end

@interface MCExportRule (MCTempTableNaming)

- (NSString *)tempTableName;

@end

